/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.global;

import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.SubGuiEditText;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface2;
import noppes.npcs.client.gui.util.GuiCustomScroll;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.GuiNpcTextField;
import noppes.npcs.client.gui.util.ICustomScrollListener;
import noppes.npcs.client.gui.util.IGuiCustomScroll;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.IGuiNpcTextField;
import noppes.npcs.client.gui.util.ISubGuiListener;
import noppes.npcs.client.gui.util.ITextfieldListener;
import noppes.npcs.client.gui.util.SubGuiInterface;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.containers.ContainerNPCTransportSetup;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.data.TransportCategory;
import noppes.npcs.controllers.data.TransportLocation;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.Util;

public class GuiNPCManageTransporters
extends GuiContainerNPCInterface2
implements IGuiData,
ISubGuiListener,
ICustomScrollListener,
ITextfieldListener {
    public final Map<String, Integer> dataCat = new TreeMap<String, Integer>();
    public final Map<String, Integer> dataLoc = new TreeMap<String, Integer>();
    private GuiCustomScroll categories;
    private GuiCustomScroll locations;
    public String catSel = "";
    public String locSel = "";
    private boolean wait = true;
    private final ContainerNPCTransportSetup container;

    public GuiNPCManageTransporters(EntityNPCInterface npc, ContainerNPCTransportSetup container) {
        super(npc, (Container)container);
        this.field_147000_g = 200;
        Client.sendData(EnumPacketServer.TransportCategoriesGet, new Object[0]);
        this.setBackground("tradersetup.png");
        this.container = container;
        if (TransportController.getInstance().categories.containsKey(container.catId)) {
            TransportCategory category = TransportController.getInstance().categories.get(container.catId);
            this.catSel = "\u00a77ID: " + container.catId + " \"" + '\u00a7' + "r" + new TextComponentTranslation(category.title, new Object[0]).func_150254_d() + '\u00a7' + "7\"";
            this.dataCat.put(this.catSel, container.catId);
        }
        if (container.location.id > -1) {
            this.locSel = "\u00a77ID: " + container.location.id + " \"" + '\u00a7' + "r" + new TextComponentTranslation(container.location.name, new Object[0]).func_150254_d() + '\u00a7' + "7\"";
        }
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        TransportCategory cat = null;
        TransportLocation loc = this.container.location;
        if (!this.catSel.isEmpty()) {
            cat = TransportController.getInstance().categories.get(this.dataCat.get(this.catSel));
        }
        switch (button.getID()) {
            case 0: {
                this.setSubGui(new SubGuiEditText(0, Util.instance.deleteColor(new TextComponentTranslation("gui.new", new Object[0]).func_150254_d())));
                break;
            }
            case 1: {
                if (cat == null) {
                    return;
                }
                Client.sendData(EnumPacketServer.TransportCategoryRemove, cat.id);
                break;
            }
            case 2: {
                this.transfer(loc);
                break;
            }
            case 3: {
                if (loc == null) {
                    return;
                }
                loc.type = button.getValue();
            }
        }
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        if (!this.locSel.isEmpty()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int slotId = 0; slotId < 10; ++slotId) {
                int x = this.field_147003_i + this.container.func_75139_a((int)slotId).field_75223_e;
                int y = this.field_147009_r + this.container.func_75139_a((int)slotId).field_75221_f;
                this.field_146297_k.func_110434_K().func_110577_a(GuiNPCInterface.RESOURCE_SLOT);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(x - 1, y - 1, 0, 0, 18, 18);
            }
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (!this.wait && !this.catSel.isEmpty()) {
            this.func_73730_a(this.field_147003_i + 212, this.field_147003_i + this.field_146999_f - 3, this.field_147009_r + 178, Integer.MIN_VALUE);
            this.func_73728_b(this.field_147003_i + 211, this.field_147009_r + 4, this.field_147009_r + this.field_147000_g + 12, Integer.MIN_VALUE);
            if (!this.locSel.isEmpty()) {
                this.func_73728_b(this.field_147003_i + 271, this.field_147009_r + 4, this.field_147009_r + 111, Integer.MIN_VALUE);
                this.func_73730_a(this.field_147003_i + 212, this.field_147003_i + 270, this.field_147009_r + 110, Integer.MIN_VALUE);
            }
            this.func_73728_b(this.field_147003_i + 418, this.field_147009_r + 4, this.field_147009_r + this.field_147000_g + 12, Integer.MIN_VALUE);
        }
    }

    @Override
    public void func_73866_w_() {
        if (this.wait) {
            super.func_73866_w_();
            return;
        }
        super.func_73866_w_();
        if (this.categories == null) {
            this.categories = new GuiCustomScroll(this, 0);
            this.categories.setSize(100, 96);
        }
        this.categories.setListNotSorted(new ArrayList<String>(this.dataCat.keySet()));
        int x = this.field_147003_i + 5;
        int y = this.field_147009_r + 14;
        this.categories.guiLeft = x;
        this.categories.guiTop = y;
        this.addScroll(this.categories);
        if (!this.catSel.isEmpty()) {
            this.categories.setSelected(this.catSel);
        }
        this.addLabel(new GuiNpcLabel(0, "gui.categories", this.field_147003_i + 5, y - 10));
        GuiNpcButton button = new GuiNpcButton(0, x, y += this.categories.field_146295_m + 2, 49, 20, "gui.add");
        button.setHoverText("manager.hover.transport.add", new Object[0]);
        this.addButton(button);
        button = new GuiNpcButton(1, x + 52, y, 49, 20, "gui.remove");
        button.setEnabled(!this.catSel.isEmpty());
        button.setHoverText("manager.hover.transport.del", "\"" + this.catSel + "\"");
        this.addButton(button);
        if (this.locations == null) {
            this.locations = new GuiCustomScroll(this, 1);
            this.locations.setSize(100, 96);
        }
        this.locations.setListNotSorted(new ArrayList<String>(this.dataLoc.keySet()));
        y = this.field_147009_r + 14;
        this.locations.guiLeft = x += 102;
        this.locations.guiTop = y;
        this.addScroll(this.locations);
        if (!this.locSel.isEmpty()) {
            this.locations.setSelected(this.locSel);
        }
        this.addLabel(new GuiNpcLabel(1, "gui.location", this.field_147003_i + 113, y - 10));
        button = new GuiNpcButton(2, x, y += this.locations.field_146295_m + 2, 100, 20, "transporter.travel");
        button.setEnabled(!this.locSel.isEmpty());
        button.setHoverText("hover.teleport", new Object[0]);
        this.addButton(button);
        if (this.catSel.isEmpty()) {
            return;
        }
        TransportCategory cat = TransportController.getInstance().categories.get(this.dataCat.get(this.catSel));
        if (cat == null) {
            return;
        }
        y = this.field_147009_r + 191;
        this.addLabel(new GuiNpcLabel(2, "parameter.ikeysetting.catname", this.field_147003_i + 216, y - 10));
        GuiNpcTextField textField = new GuiNpcTextField(0, (GuiScreen)this, this.field_146289_q, this.field_147003_i + 214, y, 132, 20, cat.title);
        textField.setHoverText("manager.hover.transport.cat.name", new Object[0]);
        this.addTextField(textField);
        if (this.locSel.isEmpty()) {
            return;
        }
        x = this.field_147003_i + 214;
        y = this.field_147009_r + 8;
        this.addLabel(new GuiNpcLabel(3, "market.barter", x + 2, y));
        this.addLabel(new GuiNpcLabel(4, "market.currency", x + 2, (y += 80) - 10));
        textField = new GuiNpcTextField(1, (GuiScreen)this, x, y, 50, 20, "" + this.container.location.money);
        textField.setMinMaxDefault(0L, Integer.MAX_VALUE, (int)this.container.location.money);
        textField.setHoverText("manager.hover.transport.money", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(5, "parameter.ikeysetting.name", x + 2, (y += 34) - 10));
        textField = new GuiNpcTextField(2, (GuiScreen)this, this.field_146289_q, x, y, 202, 20, this.container.location.name);
        textField.setHoverText("manager.hover.transport.loc.name", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(6, "UUID NPC", x + 2, (y += 34) - 11));
        textField = new GuiNpcTextField(3, (GuiScreen)this, this.field_146289_q, x, y, 202, 20, this.container.location.npc == null ? "" : this.container.location.npc.toString());
        textField.setHoverText("parameter.entity.uuid", new Object[0]);
        this.addTextField(textField);
        y = this.field_147009_r + 20;
        this.addLabel(new GuiNpcLabel(7, "parameter.world", (x += 60) + 2, y - 11));
        this.addLabel(new GuiNpcLabel(8, "ID:", x + 2, y + 6));
        textField = new GuiNpcTextField(4, (GuiScreen)this, this.field_146289_q, x + 15, y, 42, 20, "" + this.container.location.dimension);
        textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, this.container.location.dimension);
        textField.setHoverText("parameter.dimension.id", new Object[0]);
        this.addTextField(textField);
        this.addLabel(new GuiNpcLabel(9, "parameter.position", x + 2, (y += 34) - 11));
        String idt = "ID:" + this.container.location.id;
        this.addLabel(new GuiNpcLabel(10, idt, this.field_147003_i + this.field_146999_f - this.field_146289_q.func_78256_a(idt) - 4, this.field_147009_r + 8));
        for (int i = 0; i < 3; ++i) {
            int v = i == 0 ? this.container.location.pos.func_177958_n() : (i == 1 ? this.container.location.pos.func_177956_o() : this.container.location.pos.func_177952_p());
            textField = new GuiNpcTextField(5 + i, (GuiScreen)this, this.field_146289_q, x + 1 + i * 48, y, 44, 20, "" + v);
            textField.setMinMaxDefault(Integer.MIN_VALUE, Integer.MAX_VALUE, v);
            textField.setHoverText("parameter.pos" + (i == 0 ? "x" : (i == 1 ? "y" : "z")), new Object[0]);
            this.addTextField(textField);
        }
        this.addLabel(new GuiNpcLabel(11, "gui.type", x + 2, (y += 34) - 11));
        button = new GuiNpcButton(3, x, y, 137, 20, new String[]{"transporter.discovered", "transporter.start", "transporter.interaction"}, this.container.location.type);
        button.setHoverText("manager.hover.transport.type", new Object[0]);
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 && this.subgui == null) {
            this.save();
            CustomNpcs.proxy.openGui(this.npc, EnumGuiType.MainMenuGlobal);
            return;
        }
        super.func_73869_a(c, i);
    }

    @Override
    public void save() {
        GuiNpcTextField.unfocus();
        if (this.catSel.isEmpty() || this.getTextField(0) == null) {
            return;
        }
        TransportCategory cat = TransportController.getInstance().categories.get(this.dataCat.get(this.catSel));
        if (cat == null) {
            return;
        }
        cat.title = this.getTextField(0).getFullText();
        if (this.locSel.isEmpty() || this.getTextField(1) == null) {
            NBTTagCompound compound = new NBTTagCompound();
            cat.writeNBT(compound);
            Client.sendData(EnumPacketServer.TransportCategorySave, compound);
            return;
        }
        this.container.location.money = this.getTextField(1).getInteger();
        this.container.location.name = this.getTextField(2).getFullText();
        this.container.location.dimension = this.getTextField(4).getInteger();
        this.container.location.pos = new BlockPos(this.getTextField(5).getInteger(), this.getTextField(6).getInteger(), this.getTextField(7).getInteger());
        try {
            this.container.location.npc = UUID.fromString(this.getTextField(3).getFullText());
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
        this.container.location.type = this.getButton(3).getValue();
        Client.sendData(EnumPacketServer.TransportCategorySave, this.container.saveTransport(cat));
    }

    @Override
    public void scrollClicked(int mouseX, int mouseY, int mouseButton, IGuiCustomScroll scroll) {
        switch (scroll.getID()) {
            case 0: {
                if (this.catSel.equals(scroll.getSelected()) || !this.dataCat.containsKey(scroll.getSelected())) {
                    return;
                }
                this.save();
                NoppesUtil.requestOpenGUI(EnumGuiType.ManageTransport, this.container.location.id, this.dataCat.get(scroll.getSelected()), 0);
                this.wait = true;
                this.func_73866_w_();
                break;
            }
            case 1: {
                if (this.locSel.equals(scroll.getSelected()) || !this.dataLoc.containsKey(scroll.getSelected()) || !this.dataCat.containsKey(this.catSel)) {
                    return;
                }
                this.save();
                NoppesUtil.requestOpenGUI(EnumGuiType.ManageTransport, this.dataLoc.get(scroll.getSelected()), this.dataCat.get(this.catSel), 0);
                this.wait = true;
                this.func_73866_w_();
            }
        }
        this.setGuiData(null);
    }

    @Override
    public void scrollDoubleClicked(String select, IGuiCustomScroll scroll) {
        if (scroll.getID() == 1 && scroll.hasSelected()) {
            this.transfer(this.container.location);
        }
    }

    @Override
    public void setGuiData(NBTTagCompound compound) {
        int selCatId = -1;
        if (!this.catSel.isEmpty()) {
            selCatId = this.dataCat.get(this.catSel);
        }
        this.dataCat.clear();
        this.dataLoc.clear();
        for (int catId : TransportController.getInstance().categories.keySet()) {
            TransportCategory cat = TransportController.getInstance().categories.get(catId);
            String catKey = "\u00a77ID: " + catId + " \"" + '\u00a7' + "r" + new TextComponentTranslation(cat.title, new Object[0]).func_150254_d() + '\u00a7' + "7\"";
            this.dataCat.put(catKey, catId);
            if (catId != selCatId) continue;
            for (int locId : cat.locations.keySet()) {
                String locKey = "\u00a77ID: " + locId + " \"" + '\u00a7' + "r" + new TextComponentTranslation(cat.locations.get((Object)Integer.valueOf((int)locId)).name, new Object[0]).func_150254_d() + '\u00a7' + "7\"";
                this.dataLoc.put(locKey, locId);
            }
        }
        if (!this.catSel.isEmpty() && !this.dataCat.containsKey(this.catSel)) {
            this.catSel = "";
        }
        if (!this.locSel.isEmpty() && !this.dataLoc.containsKey(this.locSel)) {
            this.locSel = "";
        }
        this.wait = false;
        this.func_73866_w_();
    }

    @Override
    public void subGuiClosed(SubGuiInterface subgui) {
        if (!(subgui instanceof SubGuiEditText) || ((SubGuiEditText)subgui).text[0].isEmpty()) {
            return;
        }
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("CategoryId", -1);
        compound.func_74778_a("CategoryTitle", ((SubGuiEditText)subgui).text[0]);
        Client.sendData(EnumPacketServer.TransportCategorySave, compound);
    }

    private void transfer(TransportLocation loc) {
        if (loc == null) {
            return;
        }
        try {
            Client.sendData(EnumPacketServer.TeleportTo, loc.dimension, loc.pos.func_177958_n(), loc.pos.func_177956_o(), loc.pos.func_177952_p());
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void unFocused(IGuiNpcTextField textField) {
        TransportCategory cat = null;
        TransportLocation loc = this.container.location;
        if (!this.catSel.isEmpty()) {
            cat = TransportController.getInstance().categories.get(this.dataCat.get(this.catSel));
        }
        switch (textField.getID()) {
            case 0: {
                if (textField.getFullText().isEmpty() || cat == null) {
                    return;
                }
                cat.title = textField.getFullText();
                break;
            }
            case 1: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                loc.money = textField.getInteger();
                break;
            }
            case 2: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                loc.name = textField.getFullText();
                break;
            }
            case 3: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                try {
                    loc.npc = UUID.fromString(textField.getFullText());
                }
                catch (Exception e) {
                    textField.setFullText(loc.npc == null ? "" : loc.npc.toString());
                }
                break;
            }
            case 4: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                int dimId = textField.getInteger();
                if (!TransportController.getInstance().worldIDs.contains(dimId)) {
                    textField.setFullText("" + loc.dimension);
                    return;
                }
                loc.dimension = dimId;
                break;
            }
            case 5: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                int y = loc.pos.func_177956_o();
                int z = loc.pos.func_177952_p();
                loc.pos = new BlockPos(textField.getInteger(), y, z);
                break;
            }
            case 6: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                int x = loc.pos.func_177958_n();
                int z = loc.pos.func_177952_p();
                loc.pos = new BlockPos(x, textField.getInteger(), z);
                break;
            }
            case 7: {
                if (textField.getFullText().isEmpty() || loc == null) {
                    return;
                }
                int x = loc.pos.func_177958_n();
                int y = loc.pos.func_177956_o();
                loc.pos = new BlockPos(x, y, textField.getInteger());
                break;
            }
        }
    }
}

